if((NOT DEFINED CMAKE_VERSION) OR (CMAKE_VERSION VERSION_LESS "3.1"))
   message(FATAL_ERROR "CMake >= 3.1 required")
endif()

include(CMakeFindDependencyMacro)
find_dependency(fmt CONFIG)

include("${CMAKE_CURRENT_LIST_DIR}/OpenALTargets.cmake")

set(OPENAL_FOUND ON)
set(OPENAL_INCLUDE_DIR $<TARGET_PROPERTY:OpenAL::OpenAL,INTERFACE_INCLUDE_DIRECTORIES>)
set(OPENAL_LIBRARY $<LINK_ONLY:OpenAL::OpenAL>)
set(OPENAL_DEFINITIONS $<TARGET_PROPERTY:OpenAL::OpenAL,INTERFACE_COMPILE_DEFINITIONS>)
set(OpenAL_VERSION 1.25.1)
set(OPENAL_VERSION_STRING 1.25.1)
