/////////////////////////////////////////////////////////////////////////////
// Name:        wx/msw/colour.h
// Purpose:     wxColourImpl class
// Author:      Julian Smart
// Created:     01/02/97
// Copyright:   (c) Julian Smart
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_COLOUR_H_
#define _WX_COLOUR_H_

#include "wx/object.h"

// ----------------------------------------------------------------------------
// Colour
// ----------------------------------------------------------------------------

class WXDLLIMPEXP_CORE wxColourImpl : public wxColourBase
{
public:
    // constructors
    // ------------
    wxColourImpl() = default;

    // accessors
    // ---------

    virtual bool IsOk() const override { return m_isInit; }

    unsigned char Red() const override { return m_red; }
    unsigned char Green() const override { return m_green; }
    unsigned char Blue() const override { return m_blue; }
    unsigned char Alpha() const override { return m_alpha ; }

    // comparison
    bool operator==(const wxColourImpl& colour) const
    {
        return m_isInit == colour.m_isInit
            && m_red == colour.m_red
            && m_green == colour.m_green
            && m_blue == colour.m_blue
            && m_alpha == colour.m_alpha;
    }

    bool operator!=(const wxColourImpl& colour) const { return !(*this == colour); }

    WXCOLORREF GetPixel() const { return m_pixel; }

public:
    WXCOLORREF m_pixel = 0;

protected:
    virtual void
    InitRGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a) override;

private:
    bool          m_isInit = false;
    unsigned char m_red = 0;
    unsigned char m_blue = 0;
    unsigned char m_green = 0;
    unsigned char m_alpha = wxALPHA_TRANSPARENT;
};

#endif // _WX_COLOUR_H_
